function varargout = matchMASC2(datastream,vars,loc,avg_time,settling_time,masc_datetime)

% Co-locates masc_particles in time and space with other ARM data,
% specifically for mean Doppler velocity below cloud base
% (see matchMASC.m for details)
%
% ---------------------------------
% Kyle E. Fitch, Maj, USAF (AFIT/CI)
% University of Utah
% Salt Lake City, Utah
% kyle.fitch@utah.edu
% 7-Oct-2019  --  Version 0.1
% ---------------------------------

% % example input
% clear all;
% load('/uufs/chpc.utah.edu/common/home/garrett-group3/fitch/Data/processed/OLI_paper_vars');
% masc_datetime = [oli_year,oli_month,oli_day,oli_hour,oli_min,oli_sec];
% clearvars -except masc_datetime
% datastream = 'met';
% vars = {'temp_mean','wspd_arith_mean','wdir_vec_mean','atmos_pressure'};
% loc = 'oli';
% avg_time = 10; % max difference b/w kollias & masc for avg'ing (min)
% settling_time = 0; % account for hydrometeor settling time (min)
% datastream = 'met';vars={'temp_mean','wspd_arith_mean','atmos_pressure'};
%     loc='oli';avg_time=10;settling_time=0; masc_datetime=double(masc_datetime);
% datastream = 'kollias'; vars = {'mean_doppler_velocity'}; 
% loc = 'oli'; avg_time = 10; settling_time = 5;
% masc_datetime = double(masc_datetime);

%% constants
datenum_min = 1/1440; % 1 minute in datenum increments

%% set other parameters based on input
if strcmp(datastream,'met') && strcmp(loc,'oli')
    ARM_data_loc = ['/uufs/chpc.utah.edu/common/home/garrett-group3/',...
        'fitch/Data/ARM/MET/OLI'];
    data_lvl = 'b1';
    
elseif strcmp(datastream,'mwr') && strcmp(loc,'oli')
    ARM_data_loc = ['/uufs/chpc.utah.edu/common/home/garrett-group3/',...
        'fitch/Data/ARM/MWR-LWP'];
    data_lvl = 'b1';
    
elseif strcmp(datastream,'skyrad') && strcmp(loc,'oli')
    ARM_data_loc = ['/uufs/chpc.utah.edu/common/home/garrett-group3/',...
        'fitch/Data/ARM/SKYRAD-Tcb'];
    data_lvl = 'b1';
elseif strcmp(datastream,'kollias') && strcmp(loc,'oli')
    ARM_data_loc = ['/uufs/chpc.utah.edu/common/home/garrett-group3/',...
        'fitch/Data/ARM/Kollias'];
    data_lvl = 'c0';
end

%% find ARM data
cd(ARM_data_loc)

file_list = dir([loc,'*']);
file_names = {file_list.name};
[new_file_list,new_fn_list] = uploaddirs_ARM3(ARM_data_loc,file_names,...
    [masc_datetime(1,1:3) 0],masc_datetime(end,1:4)); %outputs: directory list

ARM_year = nan(size(new_fn_list));
ARM_month = nan(size(new_fn_list));
ARM_day = nan(size(new_fn_list));
ARM_datenum = [];
mean_doppler_velocity = [];
disp('starting loop to build mdv data vector')
if length(vars)==1 && strcmp(vars{1},'mean_doppler_velocity')
    for m = 1:length(new_file_list)
        if m == round(length(new_file_list)/100)
            disp('matching 1% complete')
        elseif m == round(length(new_file_list)/10)
            disp('matching 10% complete');
        elseif m == round(length(new_file_list)/4)
            disp('matching 25% complete');
        elseif m == round(length(new_file_list)/2)
            disp('matching 50% complete');
        elseif m == round(length(new_file_list)*(3/4))
            disp('matching 75% complete');
        elseif m == round(length(new_file_list)*(9/10))
            disp('matching 90% complete');        
        end
    
        fn = new_fn_list{m};
        mydatestr = extractBetween(fn,[data_lvl,'.'],'.');
        ARM_year(m) = str2double(mydatestr{:}(1:4));
        ARM_month(m) = str2double(mydatestr{:}(5:6));
        ARM_day(m) = str2double(mydatestr{:}(7:8));
        ARM_time = ncread(fn,'time'); % time in seconds since midnight (s)
        ARM_datevec_base = [ARM_year(m),ARM_month(m),ARM_day(m),0,0,0];
        ARM_datetime = datetime(ARM_datevec_base) + ARM_time./(3600*24);
        ARM_datenum = [ARM_datenum;datenum(ARM_datetime)];
        ARM_cbh = ncread(fn,'cloud_base_best_estimate'); % cbh (m)
        ARM_hgt = ncread(fn,'height'); % heigh bins (m)
        ARM_mdv = ncread(fn,'mean_doppler_velocity'); % mean dopp vel (m/s)
        ARM_mdv(ARM_mdv==-9999) = nan;
        for n = 1:length(ARM_mdv)
            mean_doppler_velocity = ...
                [nanmean(ARM_mdv(ARM_hgt<ARM_cbh(n),n));mean_doppler_velocity];
        end
    end
end

%% run the loop to match times
parproc = 0;
if parproc == 1
    p = gcp('nocreate'); % if no pool, do not create new one
    if isempty(p)
         myCluster = parcluster();
         parpool(myCluster)
    end
end

for n = 1:length(vars)
    eval([vars{n},'2','= nan(size(masc_datetime,1),1);'])
end

disp('started matching loop');
for masc_var = 1:size(masc_datetime,1)
    if masc_var == round(size(masc_datetime,1)/100)
        disp('matching 1% complete')
    elseif masc_var == round(size(masc_datetime,1)/10)
        disp('matching 10% complete');
    elseif masc_var == round(size(masc_datetime,1)/4)
        disp('matching 25% complete');
    elseif masc_var == round(size(masc_datetime,1)/2)
        disp('matching 50% complete');
    elseif masc_var == round(size(masc_datetime,1)*(3/4))
        disp('matching 75% complete');
    elseif masc_var == round(size(masc_datetime,1)*(9/10))
        disp('matching 90% complete');        
    end
   
    masc_datevec = masc_datetime(masc_var,:);
    masc_datenum = datenum(masc_datevec)-settling_time.*datenum_min;
    ARM_beg = datevec(masc_datenum-(avg_time/2)*datenum_min);
    ARM_end = datevec(masc_datenum+(avg_time/2)*datenum_min);
    
    day_ind = find((ARM_year == ARM_beg(1) & ARM_month == ARM_beg(2) & ...
        ARM_day == ARM_beg(3)) | ...
        (ARM_year == ARM_end(1) & ARM_month == ARM_end(2) & ...
        ARM_day == ARM_end(3)));
    
    ARM_datenum = [];
    ARM_cbh = [];
    ARM_mdv = [];
    
    for m = 1:length(day_ind)
        fn = new_fn_list{day_ind(m)};
        ARM_time = ncread(fn,'time'); % time in seconds since midnight (s)
        ARM_datevec_base = [ARM_year(day_ind(m)),ARM_month(day_ind(m)),ARM_day(day_ind(m)),0,0,0];
        ARM_datetime = datetime(ARM_datevec_base) + ARM_time./(3600*24);
        ARM_datenum = [ARM_datenum;datenum(ARM_datetime)];
        ARM_cbh = [ARM_cbh; ncread(fn,'cloud_base_best_estimate')]; % cbh (m)
        ARM_hgt = ncread(fn,'height'); % height bins (m)
        ARM_mdv = [ARM_mdv, ncread(fn,'mean_doppler_velocity')]; % mean dopp vel (m/s)
    end
    
    ARM_mdv(ARM_mdv==-9999) = nan;
    ARM_cbh(ARM_cbh<0) = nan;
    
    datenum_diff = abs(masc_datenum-ARM_datenum);
    avg_ind = find(datenum_diff <= (avg_time/2)*datenum_min);
    if ~isempty(avg_ind)
        top_hgt = nanmean(ARM_cbh(avg_ind));
        if isnan(top_hgt)
           top_hgt = 1000; 
        end
        mean_doppler_velocity2(masc_var) = nanmean(nanmean(ARM_mdv(ARM_hgt<top_hgt,avg_ind)));
    end
end
disp('matching complete')

varargout = {};
for n = 1:length(vars)
    eval(['varargout{n} =', vars{n},'2;'])
end